<?php

namespace App\Http\Controllers;

use App\AskmIzinKeluar;
use App\DimxDim;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;

class IzinKeluarController extends ResponseController
{
    //
    public function getIzinKeluar($dimId){
        
        $izinKeluar = AskmIzinKeluar::leftJoin('hrdx_pegawai as dosen','askm_izin_keluar.dosen_wali_id','=','dosen.pegawai_id')
        ->leftJoin('hrdx_pegawai as keasramaan','askm_izin_keluar.baak_id','=','keasramaan.pegawai_id')
        ->leftJoin('hrdx_pegawai as baak','askm_izin_keluar.keasramaan_id','=','baak.pegawai_id')
        ->leftJoin('askm_r_status_request as requestDosen','askm_izin_keluar.status_request_baak','=','requestDosen.status_request_id')
        ->leftJoin('askm_r_status_request as requestKeasramaan','askm_izin_keluar.status_request_keasramaan','=','requestKeasramaan.status_request_id')
        ->leftJoin('askm_r_status_request as requestBaak','askm_izin_keluar.status_request_dosen_wali','=','requestBaak.status_request_id')
        ->where('askm_izin_keluar.dim_id','=',$dimId)
        ->orderBy('izin_keluar_id','DESC')->get([
            'askm_izin_keluar.izin_keluar_id  as izinKeluarId',
            'askm_izin_keluar.desc as keperluanIk',
            'askm_izin_keluar.rencana_berangkat as rencanaBerangkat',
            'askm_izin_keluar.rencana_kembali as rencanaKembali',
            'askm_izin_keluar.realisasi_berangkat as realisasiBerangkat',
            'askm_izin_keluar.realisasi_kembali as realisasiKembali',
            'requestDosen.status_request_id as statusDosen',
            'requestKeasramaan.status_request_id as statusKeasramaan',
            'requestBaak.status_request_id as statusBaak',
            'dosen.nama as namaDosen',
            'keasramaan.nama as namaKeasramaan',
            'baak.nama as namaBaak'
        ]);
        return $this->successResponse(200,$izinKeluar);
    }

    public function buatIzinKeluar($dimId,Request $request){
        $izinKeluar = new AskmIzinKeluar();
        $izinKeluar->dim_id = $dimId;
        $izinKeluar->rencana_berangkat = $request->rencana_berangkat;
        $izinKeluar->rencana_kembali = $request->rencana_kembali;
        $izinKeluar->desc = $request->keperluanIk;
        $izinKeluar->status_request_baak = 1;
        $izinKeluar->status_request_keasramaan = 1;
        $izinKeluar->status_request_dosen_wali = 1;
        $izinKeluar->save();

        return $this->successResponse(200,null,"Izin Keluar berhasil direquest");
    }

    public function editIzinKeluar($izinId,$id,Request $request){
        $izin = AskmIzinKeluar::where('izin_keluar_id','=',$izinId)
        ->where('dim_id','=',$id)->first();
        $izin->rencana_berangkat =$izin->rencana_berangkat==null ? $izin->rencana_berangkat : $request->rencana_berangkat;
        $izin->rencana_kembali = $izin->rencana_kembali==null ? $izin->rencana_kembali : $request->rencana_kembali;
        $izin->desc = $izin->desc==null ? $izin->desc : $request->keperluanIk;
        $izin->save();
        return $this->successResponse(200,$izin,"Izin sudah Berhasil di update");
    }
    public function cancelIzinKeluar(Request $request){
        $izin = AskmIzinKeluar::where('izin_keluar_id','=',$request->idIzin)->first();
        $izin->status_request_baak = 4;
        $izin->status_request_dosen_wali = 4;
        $izin->status_request_keasramaan = 4;
        $izin->save();
        return $this->successResponse(200,null, "Izin sudah di batalkan");
    }
    public function getDetailIzinKeluar($id, $izinId)
    {
        $izinKeluar = AskmIzinKeluar::leftJoin('hrdx_pegawai as dosen','askm_izin_keluar.dosen_wali_id','=','dosen.pegawai_id')
        ->leftJoin('hrdx_pegawai as keasramaan','askm_izin_keluar.baak_id','=','keasramaan.pegawai_id')
        ->leftJoin('hrdx_pegawai as baak','askm_izin_keluar.keasramaan_id','=','baak.pegawai_id')
        ->leftJoin('askm_r_status_request as requestDosen','askm_izin_keluar.status_request_baak','=','requestDosen.status_request_id')
        ->leftJoin('askm_r_status_request as requestKeasramaan','askm_izin_keluar.status_request_keasramaan','=','requestKeasramaan.status_request_id')
        ->leftJoin('askm_r_status_request as requestBaak','askm_izin_keluar.status_request_dosen_wali','=','requestBaak.status_request_id')
        ->leftJoin('dimx_dim as mahasiswa','askm_izin_keluar.dim_id','=','mahasiswa.dim_id')
        ->where('askm_izin_keluar.dim_id','=',$id)
        ->where('askm_izin_keluar.izin_keluar_id','=',$izinId)
        ->first([
            'mahasiswa.nama as pemohon',
            'mahasiswa.nim as nimMahasiswa',
            'askm_izin_keluar.desc as keperluanIk',
            'askm_izin_keluar.rencana_berangkat as rencanaBerangkat',
            'askm_izin_keluar.rencana_kembali as rencanaKembali',
            'askm_izin_keluar.realisasi_berangkat as realisasiBerangkat',
            'askm_izin_keluar.realisasi_kembali as realisasiKembali',
            'askm_izin_keluar.status_request_dosen_wali as statusDosen',
            'askm_izin_keluar.status_request_keasramaan as statusKeasramaan',
            'askm_izin_keluar.status_request_baak as statusBaak',
            'dosen.nama as namaDosen',
            'keasramaan.nama as namaKeasramaan',
            'baak.nama as namaBaak'
        ]);
        return $this->successResponse(200, $izinKeluar);
    }
}
